﻿using System;
using VA.TMP.Integration.VIMT.Mvi.Mappers;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd
{
    /// <summary>
    /// Map Provider Veteran Identifier to Proxy Add Request EC step.
    /// </summary>
    public class MapProviderVeteranIdentifierToProxyAddRequestEcStep : FilterBase<ProxyAddStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(ProxyAddStateObject state)
        {
            if (string.IsNullOrEmpty(state.ProviderSite) || state.PatientAndProviderSitesAreEqual || state.ProviderSideIdentifierToAdd == null || state.ExceptionOccured || state.Veteran == null) return;

            state.ProxyAddToVistaRequest = new ProxyAddMapper(state, false).Map();

            state.SerializedInstance = state.SerializedInstance + string.Format("{0}Provider {0},{1}", Environment.NewLine, PipelineUtilities.SerializeInstance(state.ProxyAddToVistaRequest));
        }
    }
}